///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _Common_H
#define _Common_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define EVENT_NONE  0
#define EVENT_INFO  1
#define EVENT_WARN  2
#define EVENT_ERROR 3

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CloseLogFile(void);
bool GetIPAddress(char *sOutAddr, int iMaxSz, const char *sInputAddr);
bool DoesServerFileExist(const char *sFile);
bool OpenLogFile(void);
bool ExcludedFromInit(const char *sCmdLine);
bool IsApplicationRunning(void);
bool IsApplicationRunningEx(void);
bool BinCompare(const void *s1, const void *s2, int iSz);

char *ResolveHost(const char *sHostName, int iAddress);
char *GetBuildMutexName(const char *sBase, int iMaxSz, char *sOutString);

int AppendDataToCmd(const char *sCmd, char *sData, int iDataSz, char *sOutBuf);
int BreakCmdFromData(const char *sBuf, int iCmdLen, int iBufSz, char *sOutBuf);
int CmdCmp(const char *sBuf, const char *sCmd);
int GetListItemlParam(HWND hWnd, int iItem, int iSubItem);

void CreateFolderStructure(char *sFullPath);
void WriteAnEvent(const char *sMessage, int iEventType);
void WriteLog(int iClientId, const char *sMessage);
void WriteLogEx(int iClientId, const char *sMessage, int iEventType);
void WriteSysLog(const char *sMessage);
void WriteSysLogEx(const char *sMessage, int iEventType);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
